/*
 * Decompiled with CFR 0.152.
 */
package pt.caf_pbs.schooldiskapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import pt.caf_pbs.schooldiskapi.exceptions.DuplicatedDataException;
import pt.caf_pbs.schooldiskapi.model.Lecture;
import pt.caf_pbs.schooldiskapi.model.Subject;

@JsonIgnoreProperties(value={"all"})
public class LectureContainer
implements Serializable {
    private List<Lecture> lectures = new ArrayList();

    public List<Lecture> getLectures() {
        return this.lectures;
    }

    public void setLectures(List<Lecture> lectures) {
        this.lectures = lectures;
    }

    private Lecture search(String initials) {
        for (Lecture lecture : this.lectures) {
            if (!lecture.isEqualTo(initials)) continue;
            return lecture;
        }
        return null;
    }

    public List<Lecture> getAll() {
        ArrayList<Lecture> newlist = new ArrayList<Lecture>();
        newlist.addAll(this.lectures);
        return newlist;
    }

    public Lecture get(String initials) {
        Lecture lecture = this.search(initials);
        return lecture;
    }

    public void add(Lecture obj) {
        Subject subject = obj.getSubject();
        Lecture lecture = this.search(subject.getInitials());
        if (lecture != null) {
            String msg = "Lecture: " + subject.getInitials() + " already exists";
            throw new DuplicatedDataException(msg);
        }
        this.lectures.add(obj);
    }

    public void remove(String initials) {
        Lecture lecture = this.search(initials);
        if (lecture != null) {
            this.lectures.remove(lecture);
        }
    }
}

